/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.filesystem.ftp.FTPPlugin;
import com.aptana.filesystem.ftp.Policy;
import com.aptana.filesystem.ftp.internal.FTPClientPool;
import com.aptana.filesystem.ftp.internal.FTPConnectionFileManager;
import com.aptana.filesystem.ftp.internal.IPoolConnectionManager;
import com.aptana.filesystem.secureftp.IFTPSConnectionFileManager;
import com.aptana.filesystem.secureftp.internal.Messages;
import com.aptana.filesystem.secureftp.internal.SSLHostValidator;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class FTPSConnectionFileManager
extends FTPConnectionFileManager
implements IFTPSConnectionFileManager {
    private boolean validateCertificate;
    private boolean noSSLSessionResumption;
    private String securityMechanism;

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean passive, String transferType, String encoding, String timezone) {
        throw new UnsupportedOperationException();
    }

    public void init(String host, int port, IPath basePath, String login, char[] password, boolean explicit, boolean passive, String transferType, String encoding, String timezone, boolean validateCertificate, boolean noSSLSessionResumption) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)Messages.FTPSConnectionFileManager_ConnectionHasBeenInitiated);
        try {
            this.pool = new FTPClientPool((IPoolConnectionManager)this);
            this.ftpClient = this.newClient();
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password == null ? EMPTY_PASSWORD : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = Policy.generateAuthId((String)"FTPS", (String)login, (String)host, (int)port);
            this.transferType = transferType;
            this.timezone = timezone != null && timezone.length() == 0 ? null : timezone;
            this.validateCertificate = validateCertificate;
            this.noSSLSessionResumption = noSSLSessionResumption;
            FTPSConnectionFileManager.initFTPSClient((SSLFTPClient)this.ftpClient, explicit, passive, encoding, validateCertificate, noSSLSessionResumption);
        }
        catch (Exception e) {
            SecureFTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.secureftp", Messages.FTPSConnectionFileManager_ConnectionInitializationFailed, (Throwable)e));
            this.ftpClient = null;
        }
    }

    protected static void initFTPSClient(SSLFTPClient ftpsClient, boolean explicit, boolean passive, String encoding, boolean validateCertificate, boolean noSSLSessionResumption) throws IOException, FTPException {
        FTPSConnectionFileManager.initFTPClient((FTPClient)ftpsClient, (boolean)passive, (String)encoding);
        ftpsClient.setImplicitFTPS(true);
        ftpsClient.setCustomValidator((SSLFTPValidator)new SSLHostValidator());
        ftpsClient.setValidateServer(validateCertificate);
        try {
            ftpsClient.getRootCertificateStore().importDefaultKeyStore();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)SecureFTPPlugin.getDefault(), (String)"Loading default root certificates failed.", (Throwable)e);
        }
        ftpsClient.setImplicitFTPS(!explicit);
        ftpsClient.setConfigFlags(0x10 | (noSSLSessionResumption ? 128 : 0));
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)Messages.FTPSConnectionFileManager_ConnectionNotInitialized);
        SSLFTPClient ftpsClient = (SSLFTPClient)this.ftpClient;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            this.cwd = null;
            this.cleanup();
            ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
            if (this.messageLogWriter == null) {
                if (context != null) {
                    Object object = context.get((Object)"command_log");
                    if (object instanceof PrintWriter) {
                        this.messageLogWriter = (PrintWriter)object;
                    } else if (object instanceof OutputStream) {
                        this.messageLogWriter = new PrintWriter((OutputStream)object);
                    }
                }
                if (this.messageLogWriter == null) {
                    this.messageLogWriter = FTPPlugin.getDefault().getFTPLogWriter();
                }
                if (this.messageLogWriter != null) {
                    this.messageLogWriter.println(MessageFormat.format("---------- FTPS {0} ----------", this.host));
                    FTPSConnectionFileManager.setMessageLogger((FTPClient)this.ftpClient, (PrintWriter)this.messageLogWriter);
                }
            } else {
                this.messageLogWriter.println(MessageFormat.format("---------- RECONNECTING - FTPS {0} ----------", this.host));
            }
            monitor.beginTask(Messages.FTPSConnectionFileManager_EstablishingConnection, -1);
            this.ftpClient.setRemoteHost(this.host);
            this.ftpClient.setRemotePort(this.port);
            while (true) {
                block45: {
                    monitor.subTask(Messages.FTPSConnectionFileManager_Connecting);
                    FTPSConnectionFileManager.connectFTPSClient((FTPClient)ftpsClient);
                    if (!ftpsClient.isImplicitFTPS()) {
                        String[] supportedMechanisms = new String[]{"TLS", "TLS-C", "SSL"};
                        boolean supportsPBSZ = true;
                        boolean supportsPROT = true;
                        try {
                            String[] features = this.ftpClient.features();
                            if (features != null && features.length > 0) {
                                int i = 0;
                                while (i < features.length) {
                                    features[i] = features[i].trim();
                                    ++i;
                                }
                                List<String> featuresList = Arrays.asList(features);
                                int i2 = 0;
                                while (i2 < supportedMechanisms.length) {
                                    if (this.securityMechanism == null && featuresList.contains("AUTH " + supportedMechanisms[i2])) {
                                        this.securityMechanism = supportedMechanisms[i2];
                                        break;
                                    }
                                    ++i2;
                                }
                                supportsPBSZ = featuresList.contains("PBSZ");
                                supportsPROT = featuresList.contains("PROT");
                            }
                        }
                        catch (Exception e) {
                            e.getCause();
                        }
                        if (this.securityMechanism != null) {
                            ftpsClient.auth(this.securityMechanism);
                        } else {
                            String[] stringArray = supportedMechanisms;
                            int n = supportedMechanisms.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String auth = stringArray[n2];
                                try {
                                    ftpsClient.auth(auth);
                                    this.securityMechanism = auth;
                                    break;
                                }
                                catch (SSLFTPCertificateException e) {
                                    throw e;
                                }
                                catch (FTPException e) {
                                    e.getCause();
                                    ++n2;
                                }
                            }
                        }
                        try {
                            if (supportsPBSZ) {
                                ftpsClient.pbsz(0);
                            }
                            if (supportsPROT) {
                                ftpsClient.prot('P');
                            }
                        }
                        catch (SSLFTPCertificateException e) {
                            throw e;
                        }
                        catch (FTPException e) {
                            if (!supportsPROT) break block45;
                            ftpsClient.prot('C');
                        }
                    }
                }
                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                    this.getOrPromptPassword(MessageFormat.format(Messages.FTPSConnectionFileManager_FTPSAuthentication, this.host), Messages.FTPSConnectionFileManager_SpecifyPassword);
                }
                Policy.checkCanceled((IProgressMonitor)monitor);
                monitor.subTask(Messages.FTPSConnectionFileManager_Authenticating);
                try {
                    this.ftpClient.login(this.login, String.copyValueOf(this.password));
                }
                catch (FTPException e) {
                    Policy.checkCanceled((IProgressMonitor)monitor);
                    if ("331".equals(this.ftpClient.getLastValidReply().getReplyCode())) {
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.FTPSConnectionFileManager_FailedAuthenticate, e.getLocalizedMessage()), (Throwable)e));
                        }
                        this.promptPassword(MessageFormat.format(Messages.FTPSConnectionFileManager_FTPSAuthentication, this.host), Messages.FTPSConnectionFileManager_PasswordNotAccepted);
                        this.safeQuit();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            if (ftpsClient.isImplicitFTPS()) {
                ftpsClient.auth('P');
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            this.changeCurrentDir(this.basePath);
            this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            if ((this.hasServerInfo || context != null && context.getBoolean("quick_connect")) && (context == null || !context.getBoolean("detect_timezone"))) {
                return;
            }
            try {
                this.getherServerInfo(context, monitor);
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.FTPSConnectionFileManager_HostNameNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (SSLFTPCertificateException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.FTPSConnectionFileManager_ServerSertificateError) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.FTPSConnectionFileManager_RemoteFolderNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.FTPSConnectionFileManager_FailedEstablishConnection) + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public FTPClient newClient() {
        try {
            return new SSLFTPClient();
        }
        catch (FTPException e) {
            SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", "", (Throwable)e));
            return null;
        }
    }

    private static void connectFTPSClient(FTPClient ftpClient) throws IOException, FTPException {
        PerformanceStats stats = PerformanceStats.getStats((String)"com.aptana.filesystem.ftp/perf/connect", (Object)FTPSConnectionFileManager.class.getName());
        stats.startRun(ftpClient.getRemoteHost());
        try {
            ftpClient.connect();
        }
        finally {
            stats.endRun();
        }
    }

    public void initAndAuthFTPClient(FTPClientInterface newFtpClient, IProgressMonitor monitor) throws IOException, FTPException {
        SSLFTPClient newFtpsClient;
        block6: {
            if (newFtpClient.connected()) {
                return;
            }
            newFtpsClient = (SSLFTPClient)newFtpClient;
            FTPSConnectionFileManager.initFTPSClient(newFtpsClient, !((SSLFTPClient)this.ftpClient).isImplicitFTPS(), FTPConnectMode.PASV.equals(this.ftpClient.getConnectMode()), this.ftpClient.getControlEncoding(), this.validateCertificate, this.noSSLSessionResumption);
            newFtpClient.setRemoteHost(this.host);
            newFtpClient.setRemotePort(this.port);
            Policy.checkCanceled((IProgressMonitor)monitor);
            FTPSConnectionFileManager.connectFTPSClient((FTPClient)newFtpsClient);
            monitor.worked(1);
            Policy.checkCanceled((IProgressMonitor)monitor);
            if (!newFtpsClient.isImplicitFTPS()) {
                newFtpsClient.auth(this.securityMechanism);
            }
            try {
                if (this.serverSupportsFeature("PBSZ")) {
                    newFtpsClient.pbsz(0);
                }
                if (this.serverSupportsFeature("PROT")) {
                    newFtpsClient.prot('P');
                }
            }
            catch (FTPException e) {
                if (!this.serverSupportsFeature("PROT")) break block6;
                newFtpsClient.prot('C');
            }
        }
        newFtpsClient.login(this.login, String.copyValueOf(this.password));
        monitor.worked(1);
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("ftps", this.login, this.host, this.port != 21 && this.port != 990 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

